import xlsxwriter
import json

workbook = xlsxwriter.Workbook('Results.xlsx')
worksheet = workbook.add_worksheet()
worksheet.write(0, 0, "Frame")
worksheet.write(0, 1, "Consistent")
worksheet.write(0, 2, "Ground Red Light")
worksheet.write(0, 3, "Detection Red Light")
worksheet.write(0, 4, "Logic Red Light")
worksheet.write(0, 5, "Combined Evaluation")
worksheet.write(0, 6, "Ground Obstacles")
worksheet.write(0, 7, "Logic Obstacles")

row = 1
col = 0
logicOutput = open("output.txt", "r")
frame = 0
red_to_green_frame_gap = 10
last_light_color = "none"
worksheet.write(0, 9, "none\n")
worksheet.write(0, 10, "Logical Accuracy")
worksheet.write(0, 11, "accuracy")
worksheet.write(0, 12, "precision")
worksheet.write(0, 13, "recall")
worksheet.write(0, 14, "f-score")
worksheet.write(0, 15, "true negative")
worksheet.write(0, 16, "true positive")
worksheet.write(0, 17, "false negative")
worksheet.write(0, 18, "false positive")

worksheet.write(3, 10, "Baseline Accuracy")
worksheet.write(3, 11, "accuracy")
worksheet.write(3, 12, "precision")
worksheet.write(3, 13, "recall")
worksheet.write(3, 14, "f-score")
worksheet.write(3, 15, "true negative")
worksheet.write(3, 16, "true positive")
worksheet.write(3, 17, "false negative")
worksheet.write(3, 18, "false positive")

worksheet.write(6, 10, "Combined Accuracy")
worksheet.write(6, 11, "accuracy")
worksheet.write(6, 12, "precision")
worksheet.write(6, 13, "recall")
worksheet.write(6, 14, "f-score")
worksheet.write(6, 15, "true negative")
worksheet.write(6, 16, "true positive")
worksheet.write(6, 17, "false negative")
worksheet.write(6, 18, "false positive")

worksheet.write(1, 11, "=(P2+Q2)/(P2+Q2+R2+S2)")
worksheet.write(1, 12, "=Q2/(Q2+S2)")
worksheet.write(1, 13, "=Q2/(Q2+R2)")
worksheet.write(1, 14, "=2*((M2*N2)/(M2+N2))")
worksheet.write(1, 15, "=COUNTIFS(C:C,\"*false*\", E:E, \"*false*\")")
worksheet.write(1, 16, "=COUNTIFS(C:C,\"*true*\", E:E, \"*true*\")")
worksheet.write(1, 17, "=COUNTIFS(C:C,\"*true*\", E:E, \"*false*\")")
worksheet.write(1, 18, "=COUNTIFS(C:C,\"*false*\", E:E, \"*true*\")")

worksheet.write(4, 11, "=(P5+Q5)/(P5+Q5+R5+S5)")
worksheet.write(4, 12, "=Q5/(Q5+S5)")
worksheet.write(4, 13, "=Q5/(Q5+R5)")
worksheet.write(4, 14, "=2*((M5*N5)/(M5+N5))")
worksheet.write(4, 15, "=COUNTIFS(C:C,\"*false*\", D:D, \"*false*\")+COUNTIFS(C:C,\"*none*\", D:D, \"*false*\")")
worksheet.write(4, 16, "=COUNTIFS(C:C,\"*true*\", D:D, \"*true*\")")
worksheet.write(4, 17, "=COUNTIFS(C:C,\"*true*\", D:D, \"*false*\")")
worksheet.write(4, 18, "==COUNTIFS(C:C,\"*false*\",D:D, \"*true*\")+COUNTIFS(C:C,\"*none*\",D:D, \"*true*\")")

worksheet.write(7, 11, "=(P8+Q8)/(P8+Q8+R8+S8)")
worksheet.write(7, 12, "=Q8/(Q8+S8)")
worksheet.write(7, 13, "=Q8/(Q8+R8)")
worksheet.write(7, 14, "=2*((M8*N8)/(M8+N8))")
worksheet.write(7, 15, "=COUNTIFS(C:C,\"*false*\",F:F, \"*false*\")+COUNTIFS(C:C,\"*none*\",F:F, \"*false*\")")
worksheet.write(7, 16, "=COUNTIFS(C:C,\"*true*\", F:F, \"*true*\")")
worksheet.write(7, 17, "=COUNTIFS(C:C,\"*true*\", F:F, \"*false*\")")
worksheet.write(7, 18, "=COUNTIFS(C:C,\"*false*\",F:F, \"*true*\")+COUNTIFS(C:C,\"*none*\",F:F, \"*true*\")")

for predicate in logicOutput:
    if red_to_green_frame_gap == 10:
        if int(col) == 2:
            if str(predicate)[:-1] == "false" and last_light_color[:-1] == "true":
                red_to_green_frame_gap = 0
            last_light_color = str(predicate)
        if int(col) == 5:
            worksheet.write(row, col, "=IF(D"+str(row+1)+"<>E"+str(row+1)+",IF(EXACT(E"+str(row+1)+",$J$1),D"+str(row+1)+",E"+str(row+1)+"),D"+str(row+1)+")")
            col = col+1
        worksheet.write(row, col, predicate)
    if col == 0:
        frame = predicate
    col = col + 1
    if (col > 7):
        col = 0
        row = row+1
        if(red_to_green_frame_gap < 10):
            red_to_green_frame_gap += 1
            row = row-1
    if red_to_green_frame_gap < 10 and col == 5:
        col = col+1
workbook.close()




